/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.event;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.domain.DomainIdentifier;
import com.ibm.hwmca.fw.log.LogEntryId;
import com.ibm.hwmca.fw.pa.incident.Incident;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.event.CommonServiceEvent;
import com.ibm.hwmca.xfw.pa.event.PooledEvent;
import java.lang.reflect.Constructor;

public class CommonDataEvent
extends CommonServiceEvent
implements PooledEvent {
    private static final String TRACE_MASKT = "XPACDEVT";
    private static final String TRACE_MASKF = "XPACDEVF";
    private static final String TRACE_MASKD = "XPACDEVD";
    private static final Class[] CONSTRUCTOR_SIGNATURE_1 = new Class[]{new Object().getClass()};
    private static final Class[] CONSTRUCTOR_SIGNATURE_2 = new Class[]{new Object().getClass(), new String().getClass()};

    public CommonDataEvent(Object source) {
        super(source);
        Trace.trace(TRACE_MASKD, "<-> ctor");
        this.getMetaData().setMeta("pdc_DOMAIN_ID", "Not Set");
        this.getMetaData().setMeta("pdc_DATA_ID", "Not Set");
        this.setConsoleLogId("Not Set");
        this.updateIncidentPoolId();
    }

    public CommonDataEvent(Object source, String evtId) {
        this(source);
        this.updateFromEventId(evtId);
    }

    public static CommonDataEvent rebuildEvent(Object source, String evtId) {
        CommonDataEvent cde;
        block8: {
            Trace.trace(TRACE_MASKD, "--> rebuildEvent:" + evtId);
            cde = null;
            try {
                String className = evtId.substring(0, evtId.indexOf("//"));
                Constructor<?> evtConstructor = null;
                try {
                    evtConstructor = Class.forName(className).getConstructor(CONSTRUCTOR_SIGNATURE_2);
                }
                catch (Exception e) {
                    evtConstructor = null;
                }
                if (evtConstructor != null) {
                    cde = (CommonDataEvent)evtConstructor.newInstance(source, evtId);
                    break block8;
                }
                try {
                    evtConstructor = Class.forName(className).getConstructor(CONSTRUCTOR_SIGNATURE_1);
                }
                catch (Exception e) {
                    throw new HException("Can't find necessary constructor for event");
                }
                if (evtConstructor != null) {
                    cde = (CommonDataEvent)evtConstructor.newInstance(source);
                    cde.updateFromEventId(evtId);
                    break block8;
                }
                throw new HException("Can't find necessary constructor for event");
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKT, "couldn't rebuild event");
                Trace.trace(TRACE_MASKT, e);
            }
        }
        Trace.trace(TRACE_MASKD, "<-- rebuildEvent");
        return cde;
    }

    public String getEventId() {
        return (String)this.getMetaData().getMeta("pdc_EVENT_ID");
    }

    public void setEventId(String evtId) {
        this.getMetaData().setMeta("pdc_EVENT_ID", evtId);
    }

    public void updateFromEventId(String evtId) {
        String noClass = evtId.substring(evtId.indexOf("//") + "//".length());
        String domainId = noClass.substring(0, noClass.indexOf("//"));
        String noDomain = noClass.substring(noClass.indexOf("//") + "//".length());
        String dataId = noDomain.substring(0, noDomain.indexOf("//"));
        String consoleLogString = noDomain.substring(noDomain.indexOf("//") + "//".length());
        this.getMetaData().setMeta("pdc_DOMAIN_ID", domainId);
        this.getMetaData().setMeta("pdc_DATA_ID", dataId);
        this.setConsoleLogId(consoleLogString);
        this.updateIncidentPoolId();
    }

    public Incident getIncident() {
        return (Incident)this.getMetaData().getMeta("pdc_INCIDENT");
    }

    public void setIncident(Incident incident) {
        this.getMetaData().setMeta("pdc_INCIDENT", incident);
    }

    public void updateEventId() {
        this.setEventId(this.getClass().getName() + "//" + this.getDomainId().getDID() + "//" + this.getDataId() + "//" + this.getConsoleLogIdString());
    }

    public DomainIdentifier getDomainId() {
        String domainString = (String)this.getMetaData().getMeta("pdc_DOMAIN_ID");
        if (domainString == null) {
            return null;
        }
        return new DomainIdentifier(domainString);
    }

    public void setDomainId(String domainId) {
        this.getMetaData().setMeta("pdc_DOMAIN_ID", domainId);
        this.updateEventId();
        this.updateIncidentPoolId();
    }

    public void setDomainId(DomainIdentifier domainId) {
        this.setDomainId(domainId.getDID());
    }

    public String getDataId() {
        return (String)this.getMetaData().getMeta("pdc_DATA_ID");
    }

    public void setDataId(String dataId) {
        this.getMetaData().setMeta("pdc_DATA_ID", dataId);
        this.updateEventId();
        this.updateIncidentPoolId();
    }

    public String getConsoleLogIdString() {
        return (String)this.getMetaData().getMeta("pdc_CONSOLE_LOG_ID");
    }

    public LogEntryId getConsoleLogId() {
        String consoleLogString = this.getConsoleLogIdString();
        if (consoleLogString == null || consoleLogString.equals("Not Set")) {
            return null;
        }
        return LogEntryId.buildFromIdString(consoleLogString);
    }

    public void setConsoleLogId(String consoleLogString) {
        if (consoleLogString == null) {
            this.getMetaData().setMeta("pdc_CONSOLE_LOG_ID", "Not Set");
        } else {
            this.getMetaData().setMeta("pdc_CONSOLE_LOG_ID", consoleLogString);
        }
        this.updateEventId();
    }

    public void setConsoleLogId(LogEntryId consoleLogId) {
        if (consoleLogId == null) {
            this.setConsoleLogId("Not Set");
        } else {
            this.setConsoleLogId(consoleLogId.toIdString());
        }
    }

    public String getIncidentPoolId() {
        return (String)this.getMetaData().getMeta("pdc_IP_ID");
    }

    public void setIncidentPoolId(String poolId) {
        this.getMetaData().setMeta("pdc_IP_ID", poolId);
    }

    public void updateIncidentPoolId() {
        this.setIncidentPoolId(this.getDomainId().getDID());
    }

    public static DomainIdentifier extractDomainId(String poolId) {
        int separatorIdx = poolId.indexOf("//");
        if (separatorIdx == -1) {
            return new DomainIdentifier(poolId);
        }
        return new DomainIdentifier(poolId.substring(0, separatorIdx));
    }
}

